capture log close
clear all
macro drop _all
version 17.0
cd "C:\Users\alice\OneDrive\Alice QUANTONOMICS\Five Outputs\4 Outputs - CMOS"
set more off
set maxiter 300

**** SET PERIOD ***
local perd "long"      // can be "long" or "short"

log using Output/log/anOpexReg24-CMOS-`perd', replace text

putdocx begin
putdocx paragraph, style(Title)
putdocx text ("CMOS Opex Cost Function - `perd' period" )


display "Models: `perd'"

/*--------------------------------------------------------------------------
Project: Quantonomics DNSP Opex Cost Function Development
		Opex Cost Function Including Output CMOS 
Author:  Alice Giovani
File:    anOpexReg24-CMOS.do
Initial Date:  13May2025
Revised Date:  28May2025	

--------------------------------------------------------------------------*/
tempfile data data1

* Period & dependent variable

if "`perd'" == "long" {
	local startyr 2006
	}
else if "`perd'" == "short" {
	local startyr 2012
}
local endyr   2023

* 

scalar define ppp_aust   		   = 1.527404363
scalar define ppp_nz    		   = 1.482877481
scalar define ppp_canada		   = 1.249076963

scalar define propex_rebase_aust   = 1.238501756
scalar define propex_rebase_nz     = 1.219668445
scalar define propex_rebase_canada = 1.160126855  

* Read data

use Input/DNSPopex24-5out.dta, clear
xtset eiid year

gen int dnsp = eiid - 1000 if country == 1
qui tabulate dnsp, gen(d)
forvalues k = 1/13 {
	replace d`k' = 0 if d`k' == .
}

tabulate country, gen(jur)
correlate custnum circlen rmdem shareugc
tabulate year

summarize d* jur*

* Sample selection
*-------------------------

drop if country == 3 & year < (`startyr' - 1)
drop if country < 3 & year < `startyr'
drop if country == 3 & year > (`endyr' - 1)
drop if country < 3 & year > `endyr'

* Modify & create variables
*--------------------------

* Adressing change of VIC's DNSP from calendar to financial year in 2021

generate yr=year
replace yr=yr+0.5 if dnsp==3 & year<2021
replace yr=yr+0.5 if dnsp==8 & year<2021
replace yr=yr+0.5 if dnsp==9 & year<2021
replace yr=yr+0.5 if dnsp==11 & year<2021
replace yr=yr+0.5 if dnsp==13 & year<2021
replace yr=yr-0.25 if country==2
replace yr=yr+0.5 if country==3

replace propex = propex / propex_rebase_aust    if country==1
replace propex = propex / propex_rebase_nz      if country==2
replace propex = propex / propex_rebase_canada  if country==3
replace propex = propex * ppp_nz / ppp_aust     if country==2
replace propex = propex * ppp_canada / ppp_aust if country==3

*gen lastob = 0
*replace lastob = 1 if dnsp != dnsp[_n+1]

* Regression log variables

gen lvc = log(opex / propex)
gen ly1 = log(custnum)
gen ly2 = log(circlen)
gen ly3 = log(rmdem)
gen ly4 = log(CMOS)
gen lz1 = log(shareugc)

* mean correct output data

qui reg ly1
predict mly1
replace ly1=ly1-mly1
qui reg ly2
predict mly2
replace ly2=ly2-mly2
qui reg ly3
predict mly3
replace ly3=ly3-mly3
qui reg ly4
predict mly4
replace ly4=ly4-mly4

* TLG variables

gen ly11 = (ly1^2)/2
gen ly12 = ly1*ly2
gen ly13 = ly1*ly3
gen ly14 = ly1*ly4
gen ly22 = (ly2^2)/2
gen ly23 = ly2*ly3
gen ly24 = ly2*ly4
gen ly33 = (ly3^2)/2
gen ly34 = ly3*ly4
gen ly44 = (ly4^2)/2

* Labels

label variable ly1  "ln(Custnum)=x1" 
label variable ly2  "ln(CircLen)=x2" 
label variable ly3  "ln(RMDemand)=x3" 
label variable ly4  "ln(CMOS)=x4" 
label variable lz1  "ln(ShareUGC)" 
label variable ly11 "x1*x1/2" 
label variable ly12 "x1*x2" 
label variable ly13 "x1*x3" 
label variable ly13 "x1*x4" 
label variable ly22 "x2*x2/2" 
label variable ly23 "x2*x3" 
label variable ly23 "x2*x4" 
label variable ly33 "x3*x3/2"
label variable ly34 "x3*x4" 
label variable ly44 "x4*x4/2"
label variable yr   "Year" 
label variable jur2 "New Zealand" 
label variable jur3 "Ontario" 
label variable d2   "AGD" 
label variable d3   "CIT" 
label variable d4   "END" 
label variable d5   "ENX" 
label variable d6   "ERG"
label variable d7   "ESS" 
label variable d8   "JEN" 
label variable d9   "PCR" 
label variable d10  "SAP"
label variable d11  "AND" 
label variable d12  "TND" 
label variable d13  "UED"

* Regression models
*---------------------- 

*================================
* 1. LSECD
*================================

xtpcse lvc ly1 ly2 ly3 ly4 lz1 yr jur2 jur3 d2-d13, c(a) het
estimates store LSECD

* STATS TESTS
collin ly1 ly2 ly3 ly4 lz1 yr jur2 jur3 d2-d13
predict fit, xb
gen e2 = (lvc - fit)^2
summarize e2
scalar define see = sqrt(r(mean))
scalar list see
gen stude = (lvc - fit)/see
iqr stude
swilk stude

scalar k_lsecd = 21 
qui corr lvc fit
local psadjr2 = 1 - ((1 - r(rho)^2)*(r(N) - 1)/(r(N) - k_lsecd))	
display "LSECD Pseudo-adjusted R2 = " `psadjr2'

* EFFICIENCY SCORES

predictnl eff1 = 1/ max(1, 1/exp(_b[d2]), 1/exp(_b[d3]), 1/exp(_b[d4]), ///
  1/exp(_b[d5]), 1/exp(_b[d6]), 1/exp(_b[d7]), 1/exp(_b[d8]), 1/exp(_b[d9]), ///
  1/exp(_b[d10]), 1/exp(_b[d11]), 1/exp(_b[d12]), 1/exp(_b[d13])), ///
  ci(eff1_lb  eff1_ub)
gen eff    = eff1    if dnsp == 1
gen eff_lb = eff1_lb if dnsp == 1
gen eff_ub = eff1_ub if dnsp == 1

		
forvalues i = 2/13 {
  predictnl eff`i' = 1/exp(_b[d`i']) / max(1, 1/exp(_b[d2]), 1/exp(_b[d3]), ///
  1/exp(_b[d4]), 1/exp(_b[d5]), 1/exp(_b[d6]), 1/exp(_b[d7]), 1/exp(_b[d8]), ///
  1/exp(_b[d9]), 1/exp(_b[d10]), 1/exp(_b[d11]), 1/exp(_b[d12]), ///
  1/exp(_b[d13])), ci(eff`i'_lb  eff`i'_ub)
  
  replace eff    = eff`i'    if dnsp == `i'
  replace eff_lb = eff`i'_lb if dnsp == `i'
  replace eff_ub = eff`i'_ub if dnsp == `i'		
}

forval i = 1/13 {
    drop eff`i' eff`i'_lb eff`i'_ub
} 

table (country) (var), stat(mean eff eff_lb eff_ub)
collect export Output/xlsx/Stats-`perd'.xlsx, modify ///
	sheet("LSECD", replace)

table (dnsp) (var) if eiid < 2000, stat(mean eff eff_lb eff_ub)
collect export Output/xlsx/Stats-`perd'.xlsx, modify ///
	sheet("LSECD") cell(A8)

putdocx paragraph, style(Subtitle)
putdocx text ("LSECD `perd' Efficiency Scores")
table (dnsp) (var), stat(mean eff eff_lb eff_ub)
putdocx collect

* OUTPUT ELASTICITIES	

predictnl ely1 = (_b[ly1]), ci(lw_y1 up_y1)
predictnl ely2 = (_b[ly2]), ci(lw_y2 up_y2)
predictnl ely3 = (_b[ly3]), ci(lw_y3 up_y3)
predictnl ely4 = (_b[ly4]), ci(lw_y4 up_y4)
predictnl elY  = (_b[ly1] + _b[ly2] + _b[ly3]+ _b[ly4]), ci(lw_Y up_Y)

label var ely1 "ely1"
label var ely2 "ely2"
label var ely3 "ely3"
label var ely4 "ely4"
label var elY  "elY"
label var lw_y1 "lw_y1"
label var up_y1 "up_y1"
label var lw_y2 "lw_y2"
label var up_y2 "up_y2"
label var lw_y3 "lw_y3"
label var up_y3 "up_y3"
label var lw_y4 "lw_y4"
label var up_y4 "up_y4"
label var lw_Y  "lw_Y"
label var up_Y  "up_Y"

table (country) (var), stat(mean ely1 lw_y1 up_y1)
collect export Output/xlsx/Stats-`perd'.xlsx, modify ///
	sheet("LSECD") cell(A25)
	
table (country) (var), stat(mean ely2 lw_y2 up_y2)
collect export Output/xlsx/Stats-`perd'.xlsx, modify ///
	sheet("LSECD") cell(A32)
	
table (country) (var), stat(mean ely3 lw_y3 up_y3)
collect export Output/xlsx/Stats-`perd'.xlsx, modify ///
	sheet("LSECD") cell(A39)

table (country) (var), stat(mean ely4 lw_y4 up_y4)
collect export Output/xlsx/Stats-`perd'.xlsx, modify ///
	sheet("LSECD") cell(A46)

table (country) (var), stat(mean elY lw_Y up_Y)
collect export Output/xlsx/Stats-`perd'.xlsx, modify ///
	sheet("LSECD") cell(A53)	
	
putdocx paragraph, style(Subtitle)
putdocx text ("LSECD `perd' Elasticities")
table (country) (var) , stat(mean ely1 ely2 ely3 ely4 elY) nformat(%5.3f)
putdocx collect

	
drop ely1 lw_y1 up_y1 ely2 lw_y2 up_y2 ely3 lw_y3 up_y3 ely4 lw_y4 up_y4 ///
	 elY lw_Y up_Y eff eff_lb eff_ub fit e2 stude

*================================
* 2. LSETLG
*================================

xtpcse lvc ly1 ly2 ly3 ly4 ly11 ly12 ly13 ly14 ly22 ly23 ly24 ly33 ly34 ly44 ///
	   lz1 yr jur2 jur3 d2-d13, c(a) het
estimates store LSETLG

* STATS TESTS
collin ly1 ly2 ly3 ly4 ly11 ly12 ly13 ly14 ly22 ly23 ly24 ly33 ly34 ly44 ///
	   lz1 yr jur2 jur3 d2-d13
test ly11 ly12 ly13 ly14 ly22 ly23 ly24 ly33 ly34 ly44

predict fit, xb
gen e2 = (lvc - fit)^2
summarize e2
scalar define see = sqrt(r(mean))
scalar list see
gen stude = (lvc - fit)/see
iqr stude
swilk stude

scalar k_lsecd = 31
qui corr lvc fit
local psadjr2 = 1 - ((1 - r(rho)^2)*(r(N) - 1)/(r(N) - k_lsecd))	
display "LSETLG Pseudo-adjusted R2 = " `psadjr2'

*EFFICIENCY SCORES

predictnl eff1 = 1/ max(1, 1/exp(_b[d2]), 1/exp(_b[d3]), 1/exp(_b[d4]), ///
  1/exp(_b[d5]), 1/exp(_b[d6]), 1/exp(_b[d7]), 1/exp(_b[d8]), 1/exp(_b[d9]), ///
  1/exp(_b[d10]), 1/exp(_b[d11]), 1/exp(_b[d12]), 1/exp(_b[d13])), ///
  ci(eff1_lb  eff1_ub)
gen eff    = eff1    if dnsp == 1
gen eff_lb = eff1_lb if dnsp == 1
gen eff_ub = eff1_ub if dnsp == 1
	
forvalues i = 2/13 {
  predictnl eff`i' = 1/exp(_b[d`i']) / max(1, 1/exp(_b[d2]), 1/exp(_b[d3]), ///
  1/exp(_b[d4]), 1/exp(_b[d5]), 1/exp(_b[d6]), 1/exp(_b[d7]), 1/exp(_b[d8]), ///
  1/exp(_b[d9]), 1/exp(_b[d10]), 1/exp(_b[d11]), 1/exp(_b[d12]), ///
  1/exp(_b[d13])), ci(eff`i'_lb  eff`i'_ub)
  
  replace eff    = eff`i'    if dnsp == `i'
  replace eff_lb = eff`i'_lb if dnsp == `i'
  replace eff_ub = eff`i'_ub if dnsp == `i'		
}

forval i = 1/13 {
    drop eff`i' eff`i'_lb eff`i'_ub
} 

table (country) (var), stat(mean eff eff_lb eff_ub)
collect export Output/xlsx/Stats-`perd'.xlsx, modify ///
	sheet("LSETLG", replace)

table (dnsp) (var) if eiid < 2000, stat(mean eff eff_lb eff_ub)
collect export Output/xlsx/Stats-`perd'.xlsx, modify ///
	sheet("LSETLG") cell(A8)

putdocx paragraph, style(Subtitle)
putdocx text ("LSETLG `perd' Efficiency Scores")
table (dnsp) (var), stat(mean eff eff_lb eff_ub)
putdocx collect

* OUTPUT ELASTICITIES	
predictnl ely1 = (_b[ly1] + _b[ly11]*ly1 + _b[ly12]*ly2 + _b[ly13]*ly3 /// 
		+ _b[ly14]*ly4), ci(lw_y1 up_y1) p(p1)
predictnl ely2 = (_b[ly2] + _b[ly12]*ly1 + _b[ly22]*ly2 + _b[ly23]*ly3 ///
		+ _b[ly24]*ly4), ci(lw_y2 up_y2) p(p2)
predictnl ely3 = (_b[ly3] + _b[ly13]*ly1 + _b[ly23]*ly2 + _b[ly33]*ly3 ///
	    + _b[ly34]*ly4), ci(lw_y3 up_y3) p(p3)
predictnl ely4 = (_b[ly4] + _b[ly14]*ly1 + _b[ly24]*ly2 + _b[ly34]*ly3 /// 
		+ _b[ly44]*ly4), ci(lw_y4 up_y4) p(p4)
predictnl elY  = (_b[ly1]  + _b[ly11]*ly1 + _b[ly12]*ly2 + _b[ly13]*ly3 + _b[ly14]*ly4 ///
	 + _b[ly2] + _b[ly12]*ly1 + _b[ly22]*ly2 + _b[ly23]*ly3 + _b[ly24]*ly4 ///
	 + _b[ly3] + _b[ly13]*ly1 + _b[ly23]*ly2 + _b[ly33]*ly3 + _b[ly34]*ly4 ///
	 + _b[ly4] + _b[ly14]*ly1 + _b[ly24]*ly2 + _b[ly34]*ly3 + _b[ly44]*ly4), ci(lw_Y up_Y)

label var ely1 "ely1"
label var ely2 "ely2"
label var ely3 "ely3"
label var ely4 "ely4"
label var elY  "elY"
label var lw_y1 "lw_y1"
label var up_y1 "up_y1"
label var lw_y2 "lw_y2"
label var up_y2 "up_y2"
label var lw_y3 "lw_y3"
label var up_y3 "up_y3"
label var lw_y4 "lw_y4"
label var up_y4 "up_y4"
label var lw_Y  "lw_Y"
label var up_Y  "up_Y"

table (country) (var), stat(mean ely1 lw_y1 up_y1)
collect export Output/xlsx/Stats-`perd'.xlsx, modify ///
	sheet("LSETLG") cell(A25)
	
table (country) (var), stat(mean ely2 lw_y2 up_y2)
collect export Output/xlsx/Stats-`perd'.xlsx, modify ///
	sheet("LSETLG") cell(A32)
	
table (country) (var), stat(mean ely3 lw_y3 up_y3)
collect export Output/xlsx/Stats-`perd'.xlsx, modify ///
	sheet("LSETLG") cell(A39)

table (country) (var), stat(mean ely4 lw_y4 up_y4)
collect export Output/xlsx/Stats-`perd'.xlsx, modify ///
	sheet("LSETLG") cell(A46)
	
table (country) (var), stat(mean elY lw_Y up_Y)
collect export Output/xlsx/Stats-`perd'.xlsx, modify ///
	sheet("LSETLG") cell(A53)

table (dnsp) (var), stat(mean ely1 lw_y1 up_y1)
collect export Output/xlsx/Stats-`perd'.xlsx, modify ///
	sheet("LSETLG") cell(A70)
	
table (dnsp) (var), stat(mean ely2 lw_y2 up_y2)
collect export Output/xlsx/Stats-`perd'.xlsx, modify ///
	sheet("LSETLG") cell(A87)
	
table (dnsp) (var), stat(mean ely3 lw_y3 up_y3)
collect export Output/xlsx/Stats-`perd'.xlsx, modify ///
	sheet("LSETLG") cell(A104)

table (dnsp) (var), stat(mean ely4 lw_y4 up_y4)
collect export Output/xlsx/Stats-`perd'.xlsx, modify ///
	sheet("LSETLG") cell(A121)

putdocx paragraph, style(Subtitle)
putdocx text ("LSETLG `perd' Elasticities")
table (country) (var) , stat(mean ely1 ely2 ely3 ely4 elY) nformat(%5.3f)
putdocx collect
table (dnsp) (var) , stat(mean ely1 ely2 ely3 ely4 elY) nformat(%5.3f)
putdocx collect
	
display "MONOTONICITY VIOLATIONS"
gen mon1 = 0
gen mon2 = 0
gen mon3 = 0
gen mon4 = 0
gen montot = 0
replace mon1 = cond(ely1 < 0,1,0)	
replace mon2 = cond(ely2 < 0,1,0)	
replace mon3 = cond(ely3 < 0,1,0)
replace mon4 = cond(ely4 < 0,1,0)

replace montot = 1 if mon1 == 1 | mon2 == 1 | mon3 == 1 | mon4 == 1

tabstat mon1 mon2 mon3 mon4 montot, by(country) statistics(mean)
tabstat mon1 mon2 mon3 mon4 montot if dnsp <= 13, by(dnsp) statistics(mean) 

putdocx paragraph, style(Subtitle)
putdocx text ("LSETLG `perd'  Monotonicity Violations")
table (country) (var) , stat(mean mon1 mon2 mon3 mon4 montot) nformat(%5.3f)
putdocx collect
table (dnsp) (var) , stat(mean mon1 mon2 mon3 mon4 montot) nformat(%5.3f)
putdocx collect

export excel eiid year country custnum rmdem circlen ely1 ely2 ely3 ely4 ///
	e2 stude using Output/xlsx/monotonicity-`perd'.xlsx, ///
	sheet("LSETLG", replace) firstrow(var) 	

drop ely1 lw_y1 up_y1 ely2 lw_y2 up_y2 ely3 lw_y3 up_y3 ely4 lw_y4 up_y4 /// 
	 elY lw_Y up_Y eff eff_lb eff_ub mon1 mon2 mon3 mon4 montot e2 stude ///
	 p1 p2 p3 p4 fit


*================================
* 3. SFACD
*================================

constraint 1 _b[mu:_cons] == 0

qui reg lvc ly1 ly2 ly3 ly4 lz1 yr jur2 jur3
matrix b0 = e(b), ln(e(rmse)^2) , .1, .1
xtfrontier lvc ly1 ly2 ly3  ly4 lz1 yr jur2 jur3, cost from(b0, copy) ti ///
	diff  // constraints(1)
estimates store SFACD

* STATS TESTS
predict yhat1, xb
predict yhat2, u
gen yhat = yhat1 + yhat2	
gen eh = lvc - yhat
estat ic

scalar k_sfacd = 12		
qui corr lvc yhat
local psadjr2 = 1 - ((1 - r(rho)^2)*(r(N) - 1)/(r(N) - k_sfacd))	
display "SFACD Pseudo-adjusted R2 = " `psadjr2'

iqr eh
swilk eh
collin ly1 ly2 ly3 ly4 lz1 yr jur2 jur3

*EFFICIENCY SCORES

predict tec, te
frontier_teci tec
generate eff = 1/tec
generate eff_lb = 1/tec_u
generate eff_ub = 1/tec_l

display "EFFICIENCY SCORES"
putdocx paragraph, style(Subtitle)
putdocx text ("SFACD `perd' Efficiency Scores")

tabstat eff eff_lb eff_ub if dnsp <= 13, by(dnsp) statistics(mean)
putdocx collect
	
table (country) (var), stat(mean eff eff_lb eff_ub)
collect export Output/xlsx/Stats-`perd'.xlsx, modify ///
	sheet("SFACD", replace)
putdocx collect

table (dnsp) (var) if eiid < 2000, stat(mean eff eff_lb eff_ub)
collect export Output/xlsx/Stats-`perd'.xlsx, modify ///
	sheet("SFACD") cell(A8)

putdocx collect

* OUTPUT ELASTICITIES	

predictnl ely1 = (_b[ly1]), ci(lw_y1 up_y1)
predictnl ely2 = (_b[ly2]), ci(lw_y2 up_y2)
predictnl ely3 = (_b[ly3]), ci(lw_y3 up_y3)
predictnl ely4 = (_b[ly4]), ci(lw_y4 up_y4)
predictnl elY  = (_b[ly1] + _b[ly2] + _b[ly3]+ _b[ly4]), ci(lw_Y up_Y)

label var ely1 "ely1"
label var ely2 "ely2"
label var ely3 "ely3"
label var ely4 "ely4"
label var elY  "elY"
label var lw_y1 "lw_y1"
label var up_y1 "up_y1"
label var lw_y2 "lw_y2"
label var up_y2 "up_y2"
label var lw_y3 "lw_y3"
label var up_y3 "up_y3"
label var lw_y4 "lw_y4"
label var up_y4 "up_y4"
label var lw_Y  "lw_Y"
label var up_Y  "up_Y"


table (country) (var), stat(mean eff eff_lb eff_ub)
collect export Output/xlsx/Stats-`perd'.xlsx, modify ///
	sheet("SFACD", replace)

table (dnsp) (var) if eiid < 2000, stat(mean eff eff_lb eff_ub)
collect export Output/xlsx/Stats-`perd'.xlsx, modify ///
	sheet("SFACD") cell(A8)

table (country) (var), stat(mean ely1 lw_y1 up_y1)
collect export Output/xlsx/Stats-`perd'.xlsx, modify ///
	sheet("SFACD") cell(A25)
	
table (country) (var), stat(mean ely2 lw_y2 up_y2)
collect export Output/xlsx/Stats-`perd'.xlsx, modify ///
	sheet("SFACD") cell(A32)
	
table (country) (var), stat(mean ely3 lw_y3 up_y3)
collect export Output/xlsx/Stats-`perd'.xlsx, modify ///
	sheet("SFACD") cell(A39)

table (country) (var), stat(mean ely4 lw_y4 up_y4)
collect export Output/xlsx/Stats-`perd'.xlsx, modify ///
	sheet("SFACD") cell(A46)

table (country) (var), stat(mean elY lw_Y up_Y)
collect export Output/xlsx/Stats-`perd'.xlsx, modify ///
	sheet("SFACD") cell(A53)	
	
putdocx paragraph, style(Subtitle)
putdocx text ("SFACD `perd' Elasticities")
table (country) (var) , stat(mean ely1 ely2 ely3 ely4 elY) nformat(%5.3f)
putdocx collect

	
drop ely1 lw_y1 up_y1 ely2 lw_y2 up_y2 ely3 lw_y3 up_y3 ely4 lw_y4 up_y4 ///
     elY lw_Y up_Y eff eff_lb eff_ub tec tec_l tec_u yhat yhat1 yhat2 eh



*================================
* 4. SFATLG
*================================

qui reg lvc ly1 ly2 ly3 ly4 ly11 ly12 ly13 ly14 ly22 ly23 ly24 ly33 ly34 ly44 lz1 yr jur2 jur3
matrix b0 = e(b) 
matrix b0 = e(b), ln(e(rmse)^2) , .1, .1
xtfrontier lvc ly1 ly2 ly3 ly4 ly11 ly12 ly13 ly14 ly22 ly23 ly24 ly33 ly34 ly44  ///
	lz1 yr jur2 jur3, cost from(b0, copy) ti diff  // constraints(1)
estimates store SFATLG

* STATS TESTS

test ly11 ly12 ly13 ly22 ly23 ly33

predict fit0, xb
predict fit1, u
gen yhat = fit0 + fit1
gen eh = lvc - fit0
estat ic

gen v2 = (lvc - fit0 - fit1)^2
summarize v2
scalar define sev = sqrt(r(mean))
scalar list sev
gen studv = (lvc - fit0 - fit1)/sev
iqr studv
swilk studv
collin ly1 ly2 ly3 ly4 ly11 ly12 ly13 ly14 ly22 ly23 ly24 ly33 ly34 ly44 lz1 yr jur2 jur3

scalar k_sfatlg = 22 		
qui corr lvc yhat
local psadjr2 = 1 - ((1 - r(rho)^2)*(r(N) - 1)/(r(N) - k_sfacd))	
display "SFATLG Pseudo-adjusted R2 = " `psadjr2'

*EFFICIENCY SCORES

predict tec, te
frontier_teci tec
generate eff = 1/tec
generate eff_lb = 1/tec_u
generate eff_ub = 1/tec_l

display "EFFICIENCY SCORES"
tabstat eff eff_lb eff_ub if dnsp <= 13, by(dnsp) statistics(mean)

table (country) (var), stat(mean eff eff_lb eff_ub)
collect export Output/xlsx/Stats-`perd'.xlsx, modify ///
	sheet("SFATLG", replace)

table (dnsp) (var) if eiid < 2000, stat(mean eff eff_lb eff_ub)
collect export Output/xlsx/Stats-`perd'.xlsx, modify ///
	sheet("SFATLG") cell(A8)

putdocx paragraph, style(Subtitle)
putdocx text ("SFATLG `perd' Efficiency Scores")
table (dnsp) (var), stat(mean eff eff_lb eff_ub)
putdocx collect
table (country) (var), stat(mean eff eff_ub eff_lb)
putdocx collect


* OUTPUT ELASTICITIES	
	
predictnl ely1 = (_b[ly1] + _b[ly11]*ly1 + _b[ly12]*ly2 + _b[ly13]*ly3 /// 
		+ _b[ly14]*ly4), ci(lw_y1 up_y1) p(p1)
predictnl ely2 = (_b[ly2] + _b[ly12]*ly1 + _b[ly22]*ly2 + _b[ly23]*ly3 ///
		+ _b[ly24]*ly4), ci(lw_y2 up_y2) p(p2)
predictnl ely3 = (_b[ly3] + _b[ly13]*ly1 + _b[ly23]*ly2 + _b[ly33]*ly3 ///
	    + _b[ly34]*ly4), ci(lw_y3 up_y3) p(p3)
predictnl ely4 = (_b[ly4] + _b[ly14]*ly1 + _b[ly24]*ly2 + _b[ly34]*ly3 /// 
		+ _b[ly44]*ly4), ci(lw_y4 up_y4) p(p4)
predictnl elY  = (_b[ly1]  + _b[ly11]*ly1 + _b[ly12]*ly2 + _b[ly13]*ly3 + _b[ly14]*ly4 ///
	 + _b[ly2] + _b[ly12]*ly1 + _b[ly22]*ly2 + _b[ly23]*ly3 + _b[ly24]*ly4 ///
	 + _b[ly3] + _b[ly13]*ly1 + _b[ly23]*ly2 + _b[ly33]*ly3 + _b[ly34]*ly4 ///
	 + _b[ly4] + _b[ly14]*ly1 + _b[ly24]*ly2 + _b[ly34]*ly3 + _b[ly44]*ly4), ci(lw_Y up_Y)

label var ely1 "ely1"
label var ely2 "ely2"
label var ely3 "ely3"
label var ely4 "ely4"
label var elY  "elY"
label var lw_y1 "lw_y1"
label var up_y1 "up_y1"
label var lw_y2 "lw_y2"
label var up_y2 "up_y2"
label var lw_y3 "lw_y3"
label var up_y3 "up_y3"
label var lw_y4 "lw_y4"
label var up_y4 "up_y4"
label var lw_Y  "lw_Y"
label var up_Y  "up_Y"

table (country) (var), stat(mean ely1 lw_y1 up_y1)
collect export Output/xlsx/Stats-`perd'.xlsx, modify ///
	sheet("SFATLG") cell(A25)
	
table (country) (var), stat(mean ely2 lw_y2 up_y2)
collect export Output/xlsx/Stats-`perd'.xlsx, modify ///
	sheet("SFATLG") cell(A32)
	
table (country) (var), stat(mean ely3 lw_y3 up_y3)
collect export Output/xlsx/Stats-`perd'.xlsx, modify ///
	sheet("SFATLG") cell(A39)

table (country) (var), stat(mean ely4 lw_y4 up_y4)
collect export Output/xlsx/Stats-`perd'.xlsx, modify ///
	sheet("SFATLG") cell(A46)
	
table (country) (var), stat(mean elY lw_Y up_Y)
collect export Output/xlsx/Stats-`perd'.xlsx, modify ///
	sheet("SFATLG") cell(A53)

table (dnsp) (var), stat(mean ely1 lw_y1 up_y1)
collect export Output/xlsx/Stats-`perd'.xlsx, modify ///
	sheet("SFATLG") cell(A70)
	
table (dnsp) (var), stat(mean ely2 lw_y2 up_y2)
collect export Output/xlsx/Stats-`perd'.xlsx, modify ///
	sheet("SFATLG") cell(A87)
	
table (dnsp) (var), stat(mean ely3 lw_y3 up_y3)
collect export Output/xlsx/Stats-`perd'.xlsx, modify ///
	sheet("SFATLG") cell(A104)

table (dnsp) (var), stat(mean ely4 lw_y4 up_y4)
collect export Output/xlsx/Stats-`perd'.xlsx, modify ///
	sheet("SFATLG") cell(A121)

putdocx paragraph, style(Subtitle)
putdocx text ("SFATLG `perd' Elasticities")
table (country) (var) , stat(mean ely1 ely2 ely3 ely4 elY) nformat(%5.3f)
putdocx collect
table (dnsp) (var) , stat(mean ely1 ely2 ely3 ely4 elY) nformat(%5.3f)
putdocx collect
	
display "MONOTONICITY VIOLATIONS"
gen mon1 = 0
gen mon2 = 0
gen mon3 = 0
gen mon4 = 0
gen montot = 0
replace mon1 = cond(ely1 < 0,1,0)	
replace mon2 = cond(ely2 < 0,1,0)	
replace mon3 = cond(ely3 < 0,1,0)
replace mon4 = cond(ely4 < 0,1,0)

replace montot = 1 if mon1 == 1 | mon2 == 1 | mon3 == 1 | mon4 == 1

tabstat mon1 mon2 mon3 mon4 montot, by(country) statistics(mean)
tabstat mon1 mon2 mon3 mon4 montot if dnsp <= 13, by(dnsp) statistics(mean) 


putdocx paragraph, style(Subtitle)
putdocx text ("SFATLG `perd' Monotonicity Violations")
table (country) (var) , stat(mean mon1 mon2 mon3 mon4 montot) nformat(%5.3f)
putdocx collect
table (dnsp) (var) , stat(mean mon1 mon2 mon3 mon4 montot) nformat(%5.3f)
putdocx collect

export excel eiid year country custnum rmdem circlen ely1 ely2 ely3 ely4 ///
	v2 studv using Output/xlsx/monotonicity-`perd'.xlsx, ///
	sheet("SFATLG", replace) firstrow(var)
	 
drop ely1 lw_y1 up_y1 ely2 lw_y2 up_y2 ely3 lw_y3 up_y3 ely4 lw_y4 up_y4 ///
	elY lw_Y up_Y eff eff_lb eff_ub mon1 mon2 mon3 montot v2 p1 p2 p3 p4 fit0 fit1

* LR test
lrtest SFATLG SFACD


* Tabulating models
*--------------------

estout LSECD using Output/tsv/Reg-`perd'.tsv, ///
	cells("b(fmt(3)) se(fmt(3)) t(fmt(3))") /// 
	style(tab) label title("LSECD-`perd'") stats(r2 N, fmt(3)) replace
estout LSETLG using Output/tsv/Reg-`perd'.tsv, ///
	cells("b(fmt(3)) se(fmt(3)) t(fmt(3))") /// 
	style(tab) label title("LSETLG-`perd'") stats(r2 N, fmt(3)) append
estout SFACD using Output/tsv/Reg-`perd'.tsv, ///
	cells("b(fmt(3)) se(fmt(3)) t(fmt(3))") /// 
	style(tab) label title("SFACD-`perd'") stats(r2 N, fmt(3)) append
estout SFATLG using Output/tsv/Reg-`perd'.tsv, ///
	cells("b(fmt(3)) se(fmt(3)) t(fmt(3))") /// 
	style(tab) label title("SFATLG-`perd'") stats(r2 N, fmt(3)) append

drop _est_LSECD	_est_LSETLG	_est_SFACD	_est_SFATLG	
	
export excel using Output/xlsx/outputdata-`perd'.xlsx ///
	if eiid < 2000, firstrow(var) replace

putdocx save Output/docx/4Out-CMOS-`perd', replace


log close
exit
